            def geometry_2d(self):
                # Slot data
                l_Z2_bn = self.l_Z2_bn        # slot width
                l_Z2_hn = self.l_Z2_hn        # slot height
                
                
                #coil data
                if hasattr(self, 'n_parallels_v'):
                     n_parallels_v = self.n_parallels_v    #parallel strands in vertical #***** inja ye chiyi ro nanveshtam (currently 1)
                else:
                     1
                n_parallels_h = self.n_parallels_h    #parallel strands in horizontal
                n_turns = self.n_W_turns              #turns of strands
                
                
                #slot clearance dimensions
                l_slot_clearance_v = self.l_slot_clearance_v   #not usable slot height               
                l_slot_clearance_h = self.l_slot_clearance_h   #not usable slot width
                
                
                #copper width for stand number X
                
            
                copper_wX = getattr(self, 'copper_wX', None)     # check the presented value
                if copper_wX is None:                            # if the value is not presented, the default is 100% or 1 based on word file
                   copper_wX = np.array([1.0])
                else:
                   copper_wX = np.array(copper_wX)
                   
                   
                # Insulation data matrix
                insulation_system = self.coil_insulation_system    # Insulation data
                
                
                #Total available copper width for unpressed condition (my assumption)
                total_copper_width_ratio = np.sum(copper_wX)
                available_width = l_Z2_bn - l_slot_clearance_h  # available sidth for copper
                
                
                #Actual copper widths per strand
                copper_widths = (copper_wX / total_copper_width_ratio) * available_width
                
                
                #copper height and insulated strand height
                
                copper_heights = self.h_strand
                
                
                #Insulation data
                for i in range(0, 5):
                    if insulation_system[1][i][2] != 0:
                       insulation_thickness = insulation_system[1][i][2]          #unpressed insulation thickness         
                    elif insulation_system[1][i][3] != 0:
                       insulation_thickness = insulation_system[1][i][3]                    #pressed insulation thickness

                insulated_strand_heights = copper_heights + 2 * insulation_thickness
                
                
                #Copper rounding radius
                self.r_round_std=[0.5*self.h_strand,0.65,0.80,1]
                
                if self.h_strand<1.00:
                    self.r_round=self.r_round_std[0]
                elif self.h_strand>1.60 and self.h_strand<=2.24:
                    self.r_round=self.r_round_std[1]
                elif self.h_strand>2.24 and self.h_strand<=3.55:
                    self.r_round=self.r_round_std[2]    
                elif self.h_strand>3.55 and self.h_strand<=5.60:
                    self.r_round=self.r_round_std[3]
                else:
                    self.r_round.append(0)
                
                
                
                
                copper_rounding_radius = self.r_round
                
                
                # Data arrasy for horizontal strands(For each strand, store area, width, and insulated width, Copper area with rectangular cross-section
                copper_areas = copper_widths * copper_heights
                insulated_strand_widths = copper_widths + 2 * insulation_thickness
                # For area, assuming rectangular cross-section
                insulated_strand_areas = insulated_strand_widths * insulated_strand_heights
                
                
                # Coil dimensions
                coil_height = max(insulated_strand_heights) * n_parallels_v * n_turns       #coil height
                coil_width = l_Z2_bn - l_slot_clearance_h                                   #coil width (assumption)
                 
                # Coil area
                coil_area = coil_width * coil_height

                # Slot area
                slot_area = l_Z2_bn * l_Z2_hn

                # Filling factors
                total_copper_area = np.sum(copper_areas)
                filling_factor_copper_coil = total_copper_area / coil_area
                filling_factor_copper_slot = total_copper_area / slot_area
                
                
                
                
                # Compile results into a dictionary for output
                results = {
                    'per_strand': {
                    'copper_height': copper_heights,
                    'insulated_strand_height': insulated_strand_heights,
                    'copper_rounding_radius': copper_rounding_radius,
                    'copper_area': copper_areas,
                    'copper_width': copper_widths,
                    'insulated_strand_width': insulated_strand_widths
                         },
                 'coil': {
                    'coil_height': coil_height,
                    'coil_width': coil_width,
                    'coil_area': coil_area,
                    'slot_area': slot_area,
                    'filling_factor_copper_coil': filling_factor_copper_coil,
                    'filling_factor_copper_slot': filling_factor_copper_slot
                        }
                    }

                print(results)
               # Return the results
                return results  

        Milad = geometry_2d()
        print(Milad)  